/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			ordered_probit.do
Description: 	Ordered probit figures

Notes: 			- Created by Jeff 
				- Last updated 10/31/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"
	
	
	gen order = 0
	replace order = 1 if draw == 1
	replace order = 2 if win == 1
	
******** Doing this Ordered Logit *********
	
****** No Controls	****
	ologit order i.VAR, cluster(country)
	margins VAR 
	marginsplot, legend(order(1 "Loss" 2 "Draw" 3 "Win")) xlabel(0 "No VAR" 1 "VAR") xtitle("") ytitle("Predicted Pr(Outcome)") title("")
	gr export "${graphs}\ordered_logit_estimates_no_controls.png", replace 	
	
	ologit order i.VAR i.season i.country_num, cluster(country)
	margins VAR 
	marginsplot, legend(order(1 "Loss" 2 "Draw" 3 "Win")) xlabel(0 "No VAR" 1 "VAR") xtitle("") ytitle("Predicted Pr(Outcome)") title("")	
	gr export "${graphs}\ordered_logit_estimates_fixed_effects.png", replace 		