/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_ref_decisions.do
Description: 	Preliminary analysis tables for ref outcomes

Notes: 			- Created by Jeff 
				- Last updated 9/27/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_refs_merged", clear
	
	
**************** Assign Treatment (taken from that do-file) *****************	

	**first, create new season variable that is just the last two digits of the actual season
	gen season_last2 = .
	replace season_last2 = mod(season,100)
	**even easier than I expected

	drop if season > 1919
	**it looks like the 1920 season was still included for the top four leagues from the last project

	gen treatment_season = .
	replace treatment_season = 20 if country == "japan"
	replace treatment_season = 1920 if country == "scotland"
	replace treatment_season = 1920 if country == "denmark"
	replace treatment_season = 1920 if country == "premier_league"
	replace treatment_season = 1920 if country == "switzerland"
	replace treatment_season = 1920 if country == "russia"
	replace treatment_season = 1920 if country == "greece"

	replace treatment_season = 19 if country == "brazil"
	replace treatment_season = 1819 if country == "dutch"
	replace treatment_season = 1819 if country == "la_liga"
	replace treatment_season = 1819 if country == "france"
	replace treatment_season = 1819 if country == "turkey"


	replace treatment_season = 1718 if country == "serie_a"
	replace treatment_season = 1718 if country == "bundesliga"
	replace treatment_season = 1718 if country == "australia"
	replace treatment_season = 1718 if country == "portugal"
	*replace treatment_season = 17 if country == "korea"


	gen treatment_season_last2 = .
	replace treatment_season_last2 = mod(treatment_season,100)

	gen VAR = 0
	replace VAR = 1 if season == treatment_season
	replace VAR = 1 if season > treatment_season
********************** Create Variables for Reg **************
	encode country, gen(country_num)
	encode team_name, gen(team_num)

	gen yellow_diff = yellow_home-yellow_away
	gen red_diff = red_home-red_away
	gen fouls_diff = fouls_home-fouls_away
	gen offside_diff = caughtoffside_home-caughtoffside_away	
	
	rename caughtoffside_overall offside_overall
	
********************** New Outcome Regressions ***************	

local loop "yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/

	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local season "No" , replace
					estadd local country "No" , replace
					
	reghdfe `l' VAR, absorb(i.country_num) cluster(country) // absorbs team
					eststo `l'_country
					estadd local season "No" , replace
					estadd local country "Yes" , replace					

	reghdfe `l' VAR, absorb(i.season) cluster(country) // absorbs season and country
					eststo `l'_season
					estadd local season "Yes" , replace	
					estadd local country "No" , replace


					
	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs team and season
					eststo `l'_all
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
												
		}
		
		
		
		**** Main Tables (diffs by ref outcomes) ****
		* Yellow Cards
				#delimit  ;
					esttab yellow_diff* using "$regressions/diff-in-diff/yellow_cards_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Y^H-Y^A\$" "\$Y^H-Y^A\$" "\$Y^H-Y^A\$" "\$Y^H-Y^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Main Table (Red Cards)
				#delimit  ;
					esttab red_diff* using "$regressions/diff-in-diff/red_cards_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$R^H-R^A\$" "\$R^H-R^A\$" "\$R^H-R^A\$" "\$R^H-R^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (Fouls)
				#delimit  ;
					esttab fouls_diff* using "$regressions/diff-in-diff/fouls_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		**** Appendix Table (Offsides)
				#delimit  ;
					esttab offside_diff* using "$regressions/diff-in-diff/offside_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Off^H-Off^A\$" "\$Off^H-Off^A\$" "\$Off^H-Off^A\$" "\$Off^H-Off^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (PKs)
				#delimit  ;
					esttab pk_pg_diff* using "$regressions/diff-in-diff/pk_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$PK^H-PK^A\$" "\$PK^H-PK^A\$" "\$PK^H-PK^A\$" "\$PK^H-PK^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
					
		**** Main Tables (overall by ref outcomes) ****
		* Yellows
				#delimit  ;
					esttab yellow_overall* using "$regressions/diff-in-diff/yellow_cards_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Yellows" "Yellows" "Yellows" "Yellows") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Overall Table (Reds)
				#delimit  ;
					esttab red_overall* using "$regressions/diff-in-diff/red_cards_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Reds" "Reds" "Reds" "Reds") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (Fouls)
				#delimit  ;
					esttab fouls_overall* using "$regressions/diff-in-diff/fouls_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Fouls" "Fouls" "Fouls" "Fouls") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		**** Appendix Table (Offsides)
				#delimit  ;
					esttab offside_overall* using "$regressions/diff-in-diff/offside_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Offsides" "Offsides" "Offsides" "Offsides") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr			
					
		**** Appendix Table (pk per game)
				#delimit  ;
					esttab pk_pg_overall* using "$regressions/diff-in-diff/pk_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("PKs" "PKs" "PKs" "PKs") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
estimates clear
					
************** Event study Figure *****************************

	gen time = season
	replace time = 10 if season == 910
	replace time = 11 if season == 1011
	replace time = 12 if season == 1112
	replace time = 13 if season == 1213
	replace time = 14 if season == 1314
	replace time = 15 if season == 1415
	replace time = 16 if season == 1516
	replace time = 17 if season == 1617
	replace time = 18 if season == 1718
	replace time = 19 if season == 1819
	
	sort country season 
	gen first_year = time if country == country[_n-1] & VAR != VAR[_n-1]
	
	bys country: egen reference = max(first_year)
	
	gen t = time - reference // empty for control. Negative in the pre-period and positive in the post-period					
					
local loop "yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall"

foreach l of local loop {	

			if "`l'" == "yellow_diff" {
				local dep = "Home Yellows minus Away Yellows"
			}
			if "`l'" == "red_diff" {
				local dep = "Home Reds minus Away Reds"
			}
			if "`l'" == "fouls_diff" {
				local dep = "Home Fouls minus Away Fouls"
			}
			if "`l'" == "offside_diff" {
				local dep = "Home Offsides minus Away Offsides"
			}	
			
			if "`l'" == "pk_pg_diff" {
				local dep = "Home PKs minus Away PKs"
			}				
			
			if "`l'" == "yellow_overall" {
				local dep = "Total Yellows Given"
			}
			if "`l'" == "red_overall" {
				local dep = "Total Reds Given"
			}
			if "`l'" == "fouls_overall" {
				local dep = "Total Fouls Given"
			}
			if "`l'" == "offside_overall" {
				local dep = "Total Offsides Called"
			}		
			if "`l'" == "pk_pg_overall" {
				local dep = "Total PKs Called"
			}			
		******* Note that atm to stay consistent with the tables it has Season (not time) Fixed effects *********	
	  eventdd `l', timevar(t) ci("twoway_rcap") level(95) ///
		cluster(country) method(hdfe, absorb(i.country_num i.season)) ///
		graph_op(scheme(sj) xtitle("Seasons from VAR") title("`dep'") graphregion(color(white)))
	graph export "${graphs}/event_study_`l'.png", replace	
	
}	

********************* Robust Standard Errors (Same as above) ******************

********************** New Outcome Regressions ***************	

local loop "yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/

	reghdfe `l' VAR, noabsorb vce(robust) // 
					eststo `l'_none
					estadd local season "No" , replace
					estadd local country "No" , replace
					
	reghdfe `l' VAR, absorb(i.country_num) vce(robust) // absorbs team
					eststo `l'_country
					estadd local season "No" , replace
					estadd local country "Yes" , replace					

	reghdfe `l' VAR, absorb(i.season) vce(robust) // absorbs season and country
					eststo `l'_season
					estadd local season "Yes" , replace	
					estadd local country "No" , replace


					
	reghdfe `l' VAR, absorb(i.season i.country_num) vce(robust) // absorbs team and season
					eststo `l'_all
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
												
		}
		
		
		
		**** Main Tables (diffs by ref outcomes) ****
		* Yellow Cards
				#delimit  ;
					esttab yellow_diff* using "$regressions/diff-in-diff/yellow_cards_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Y^H-Y^A\$" "\$Y^H-Y^A\$" "\$Y^H-Y^A\$" "\$Y^H-Y^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Main Table (Red Cards)
				#delimit  ;
					esttab red_diff* using "$regressions/diff-in-diff/red_cards_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$R^H-R^A\$" "\$R^H-R^A\$" "\$R^H-R^A\$" "\$R^H-R^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (Fouls)
				#delimit  ;
					esttab fouls_diff* using "$regressions/diff-in-diff/fouls_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$" "\$Foul^H-Foul^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		**** Appendix Table (Offsides)
				#delimit  ;
					esttab offside_diff* using "$regressions/diff-in-diff/offside_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$Off^H-Off^A\$" "\$Off^H-Off^A\$" "\$Off^H-Off^A\$" "\$Off^H-Off^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (PKs)
				#delimit  ;
					esttab pk_pg_diff* using "$regressions/diff-in-diff/pk_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$PK^H-PK^A\$" "\$PK^H-PK^A\$" "\$PK^H-PK^A\$" "\$PK^H-PK^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
					
		**** Main Tables (overall by ref outcomes) ****
		* Yellows
				#delimit  ;
					esttab yellow_overall* using "$regressions/diff-in-diff/yellow_cards_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Yellows" "Yellows" "Yellows" "Yellows") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Overall Table (Reds)
				#delimit  ;
					esttab red_overall* using "$regressions/diff-in-diff/red_cards_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Reds" "Reds" "Reds" "Reds") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (Fouls)
				#delimit  ;
					esttab fouls_overall* using "$regressions/diff-in-diff/fouls_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Fouls" "Fouls" "Fouls" "Fouls") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		**** Appendix Table (Offsides)
				#delimit  ;
					esttab offside_overall* using "$regressions/diff-in-diff/offside_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Offsides" "Offsides" "Offsides" "Offsides") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
		
	*** PKs with robust SEs	
				#delimit  ;
					esttab pk_pg_overall* using "$regressions/diff-in-diff/pk_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("PKs" "PKs" "PKs" "PKs") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
estimates clear
				

foreach l of local loop {	

			if "`l'" == "yellow_diff" {
				local dep = "Home Yellows minus Away Yellows"
			}
			if "`l'" == "red_diff" {
				local dep = "Home Reds minus Away Reds"
			}
			if "`l'" == "fouls_diff" {
				local dep = "Home Fouls minus Away Fouls"
			}
			if "`l'" == "offside_diff" {
				local dep = "Home Offsides minus Away Offsides"
			}	
			
			if "`l'" == "pk_pg_diff" {
				local dep = "Home PKs minus Away PKs"
			}				
			
			if "`l'" == "yellow_overall" {
				local dep = "Total Yellows Given"
			}
			if "`l'" == "red_overall" {
				local dep = "Total Reds Given"
			}
			if "`l'" == "fouls_overall" {
				local dep = "Total Fouls Given"
			}
			if "`l'" == "offside_overall" {
				local dep = "Total Offsides Called"
			}		
			if "`l'" == "pk_pg_overall" {
				local dep = "Total PKs Called"
			}
			
******* Note that atm to stay consistent with the tables it has Season (not time) Fixed effects *********		
	  eventdd `l', timevar(t) ci("twoway_rcap") level(95) ///
		vce(robust) method(hdfe, absorb(i.country_num i.season)) ///
		graph_op(scheme(sj) xtitle("Seasons from VAR") title("`dep'") graphregion(color(white)))
	graph export "${graphs}/event_study_`l'_robust_se.png", replace	
	
}	
		