/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_ref_decisions.do
Description: 	Preliminary analysis tables for ref outcomes

Notes: 			- Created by Jeff 
				- Last updated 9/27/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_refs_merged", clear
	
	
**************** Assign Treatment (taken from that do-file) *****************	

	**first, create new season variable that is just the last two digits of the actual season
	gen season_last2 = .
	replace season_last2 = mod(season,100)
	**even easier than I expected

	drop if season > 1919
	**it looks like the 1920 season was still included for the top four leagues from the last project

	gen treatment_season = .
	replace treatment_season = 20 if country == "japan"
	replace treatment_season = 1920 if country == "scotland"
	replace treatment_season = 1920 if country == "denmark"
	replace treatment_season = 1920 if country == "premier_league"
	replace treatment_season = 1920 if country == "switzerland"
	replace treatment_season = 1920 if country == "russia"
	replace treatment_season = 1920 if country == "greece"

	replace treatment_season = 19 if country == "brazil"
	replace treatment_season = 1819 if country == "dutch"
	replace treatment_season = 1819 if country == "la_liga"
	replace treatment_season = 1819 if country == "france"
	replace treatment_season = 1819 if country == "turkey"


	replace treatment_season = 1718 if country == "serie_a"
	replace treatment_season = 1718 if country == "bundesliga"
	replace treatment_season = 1718 if country == "australia"
	replace treatment_season = 1718 if country == "portugal"
	*replace treatment_season = 17 if country == "korea"


	gen treatment_season_last2 = .
	replace treatment_season_last2 = mod(treatment_season,100)

	gen VAR = 0
	replace VAR = 1 if season == treatment_season
	replace VAR = 1 if season > treatment_season
********************** Create Variables for Reg **************
	encode country, gen(country_num)
	encode team_name, gen(team_num)

	gen yellow_diff = yellow_home-yellow_away
	gen red_diff = red_home-red_away
	gen fouls_diff = fouls_home-fouls_away
	gen offside_diff = caughtoffside_home-caughtoffside_away	
	
	rename caughtoffside_overall offside_overall
	

collapse (mean) yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall VAR country_num, by(country season)
	
********************** New Outcome Regressions ***************	

local loop "yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall"
	foreach l of local loop {
					
	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs team and season
					eststo `l'_all
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
												
		}
		
		
		
		**** Main Tables (diffs by ref outcomes) ****
				#delimit  ;
					esttab fouls_diff_all yellow_diff_all red_diff_all offside_diff_all pk_pg_diff_all using "$regressions/diff-in-diff/country_ref_diff", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles( "\$Foul^H-Foul^A\$" "\$Y^H-Y^A\$" "\$R^H-R^A\$" "\$Off^H-Off^A\$" "\$PK^H-PK^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
	
					
		**** Main Tables (overall by ref outcomes) ****
				#delimit  ;
					esttab fouls_overall_all yellow_overall_all red_overall_all offside_overall_all pk_pg_overall_all using "$regressions/diff-in-diff/country_ref_overall", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Fouls" "Yellows" "Reds" "Offsides" "PKs") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
							
estimates clear

*********************** Repeat with Robust SEs************************					

local loop "yellow_diff red_diff fouls_diff offside_diff yellow_overall red_overall fouls_overall offside_overall pk_pg_diff pk_pg_overall"
	foreach l of local loop {
					
	reghdfe `l' VAR, absorb(i.season i.country_num) vce(robust) // absorbs team and season
					eststo `l'_all
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
												
		}
		
		
		
		**** Main Tables (diffs by ref outcomes) ****
				#delimit  ;
					esttab fouls_diff_all yellow_diff_all red_diff_all offside_diff_all pk_pg_diff_all using "$regressions/diff-in-diff/country_ref_diff_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles( "\$Foul^H-Foul^A\$" "\$Y^H-Y^A\$" "\$R^H-R^A\$" "\$Off^H-Off^A\$" "\$PK^H-PK^A\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N, 
							labels("Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
	
					
		**** Main Tables (overall by ref outcomes) ****
				#delimit  ;
					esttab fouls_overall_all yellow_overall_all red_overall_all offside_overall_all pk_pg_overall_all using "$regressions/diff-in-diff/country_ref_overall_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Fouls" "Yellows" "Reds" "Offsides" "PKs") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N, 
							labels("Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
							
estimates clear					