/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_ref_decisions.do
Description: 	Preliminary analysis tables for ref outcomes

Notes: 			- Created by Jeff 
				- Last updated 9/27/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
set scheme plotplainblind
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_refs_merged", clear
	
		gen season_last2 = .
	replace season_last2 = mod(season,100)
	**even easier than I expected

	drop if season > 1919
	**it looks like the 1920 season was still included for the top four leagues from the last project

	gen treatment_season = .
	replace treatment_season = 20 if country == "japan"
	replace treatment_season = 1920 if country == "scotland"
	replace treatment_season = 1920 if country == "denmark"
	replace treatment_season = 1920 if country == "premier_league"
	replace treatment_season = 1920 if country == "switzerland"
	replace treatment_season = 1920 if country == "russia"
	replace treatment_season = 1920 if country == "greece"

	replace treatment_season = 19 if country == "brazil"
	replace treatment_season = 1819 if country == "dutch"
	replace treatment_season = 1819 if country == "la_liga"
	replace treatment_season = 1819 if country == "france"
	replace treatment_season = 1819 if country == "turkey"


	replace treatment_season = 1718 if country == "serie_a"
	replace treatment_season = 1718 if country == "bundesliga"
	replace treatment_season = 1718 if country == "australia"
	replace treatment_season = 1718 if country == "portugal"
	

	gen treatment_season_last2 = .
	replace treatment_season_last2 = mod(treatment_season,100)

	gen VAR = 0
	replace VAR = 1 if season == treatment_season
	replace VAR = 1 if season > treatment_season
********************** Create Variables for Reg **************
	encode country, gen(country_num)
	encode team_name, gen(team_num)

	gen yellow_diff = yellow_home-yellow_away
	gen red_diff = red_home-red_away
	gen fouls_diff = fouls_home-fouls_away
	gen offside_diff = caughtoffside_home-caughtoffside_away	
	
	gen yellow_neg_diff = yellow_away - yellow_home
	gen red_neg_diff = red_away - red_home
	
	rename caughtoffside_overall offside_overall	
	
	collapse (mean) yellow_diff yellow_neg_diff red_diff red_neg_diff, by(season_last2 country)
	
	bys season_last2: egen avg_yellow_neg_diff = mean(yellow_neg_diff)
	by season_last2: egen avg_yellow_diff = mean(yellow_diff)
	by season_last2: egen avg_red_neg_diff = mean(red_neg_diff)
	by season_last2: egen avg_red_diff = mean(red_diff)
	
	line avg_yellow_neg_diff season_last2, ytitle("Away - Home Yellows") xtitle("Season")
	gr export "${graphs}/trends_yellow_neg.png", replace
	
	line avg_yellow_diff season_last2, ytitle("Home - Away Yellows") xtitle("Season")
	gr export "${graphs}/trends_yellow.png", replace	
	
	line avg_red_neg_diff season_last2, ytitle("Away - Home Reds") xtitle("Season")
	gr export "${graphs}/trends_red_neg.png", replace
	
	line avg_red_diff season_last2, ytitle("Home - Away Reds") xtitle("Season")
	gr export "${graphs}/trends_red.png", replace		