/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			win_draw_updated.do
Description: 	Preliminary analysis tables

Notes: 			- Created by Jeff 
				- Last updated 1/29/2024
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"

local loop "win draw"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/

	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs season and country
					eststo `l'_fixed
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
																	
			
		}
		
		
					
		**** Appendix Table (win/draw)
				#delimit  ;
					esttab win_none win_fixed draw_none draw_fixed using "$regressions/diff-in-diff/game_outcomes_updated", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear	
			
		
reg win VAR i.season i.country_num, vce(cluster country_num)
boottest VAR, reps(1000)	// [-0.03073, .03638]

reg draw VAR i.season i.country_num, vce(cluster country_num)
boottest VAR, reps(1000)	// [-0.0261, .04896]



local loop "win draw"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/

	reghdfe `l' VAR, noabsorb vce(robust) // 
					eststo `l'_none
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) vce(robust) // absorbs season and country
					eststo `l'_fixed
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
																	
			
		}
		
		
					
		**** Appendix Table (win/draw)
				#delimit  ;
					esttab win_none win_fixed draw_none draw_fixed using "$regressions/diff-in-diff/game_outcomes_updated_robust", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear	